<?php
require "../connections/Onvif.php";
$MinServerVersion = [2, 1, 2, 1];
header("Content-Type: text/html; charset=UTF-8"); //windows-1251
header("Expires:Thu, 01 Jan 1970 00:00:01 GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Cache-Control: private");
mb_internal_encoding("UTF-8");

if (empty($_SERVER["PHP_AUTH_DIGEST"])) {
   print_unauth_header();
   die("Authentication required");
}
function isContainNull($arr)
{
   // проверка на наличие null
   foreach ($arr as $a) {
      if (is_null($a) || (is_array($a) && isContainNull($a))) {
         return true;
      }
   }
}

function isCanDoItServe($server, $prop)
{
   global $UserAccessLevel;
   if (isset($server->server->access)) {
      $serverAccess = cutAccess($server->server->access);
   } else {
      $serverAccess = (object) ["read" => 10, "write" => 10, "play" => 10, "ptz" => 10];
   }
   $userAccess = getNormalUserAccess($UserAccessLevel);
   $userAccess >= $serverAccess->$prop ? ($iscan = 1) : ($iscan = 0);
   return $iscan;
}

function cutAccess($obj)
{
   $result = (object) [];
   foreach ($obj as $key => $value) {
      if (10 % $value >= 10 && $value < 101) {
         $result->$key = $value / 10;
      } elseif ($value == 101) {
         $result->$key = 11;
      } elseif ($value == 10) {
         $result->$key = 1;
      } else {
         $result->$key = $value;
      }
   }
   return $result;
}

function getNormalUserAccess($UserAccessLevel)
{
   $access = 1;
   if (intval($UserAccessLevel) == 101) {
      $access = 11;
   } elseif (intval($UserAccessLevel) != 1) {
      $access = intval($UserAccessLevel) / 10;
   }
   return $access;
}

function getUserIndex($users)
{
   try {
      global $UserId;
      $userIndex = -1;
      $users = $users->security->user;
      foreach ($users as $user) {
         if ($UserId == $user->id) {
            $userIndex = $user->index;
            break;
         }
      }
      return $userIndex;
   } catch (\Throwable $th) {
      return $userIndex;
   }
}

function isCanDoIt($sock, $prop)
{
   global $UserAccessLevel;
   $server = ParamGet($sock, "server");
   if (isset($server->server->access)) {
      $serverAccess = cutAccess($server->server->access);
   } else {
      $serverAccess = (object) ["read" => 10, "write" => 10, "play" => 10, "ptz" => 10];
   }
   $userAccess = getNormalUserAccess($UserAccessLevel);
   $userAccess >= $serverAccess->$prop ? ($iscan = 1) : ($iscan = 0);
   return $iscan;
}

function checkActionAccess($sock, $prop)
{
   if (!isCanDoIt($sock, $prop)) {
      Header("HTTP/1.0 403 Forbidden");
      die("no rights!");
   }
}

function print_unauth_header()
{
   $realm = "DominationWebServer";
   header("HTTP/1.1 401 Unauthorized");
   /*   header('WWW-Authenticate: Digest realm="'.$realm.'",qop="auth",nonce="'.Nonce().'",opaque="'.md5($realm).'"');  */
   header("nonce:" . Nonce());
   header("opaque:" . md5($realm));
}

//if (!($data = http_digest_parse($_SERVER['PHP_AUTH_DIGEST'])))    die('Authentication required');
function http_digest_parse($txt)
{
   // protect against missing data
   $needed_parts = [
      "nonce" => 1,
      "nc" => 1,
      "cnonce" => 1,
      "qop" => 1,
      "username" => 1,
      "uri" => 1,
      "response" => 1,
   ];
   $data = [];

   preg_match_all('@(\w+)=(?:([\'"])([^$2]+)$2|([^\s,]+))@', $txt, $matches, PREG_SET_ORDER);

   foreach ($matches as $m) {
      if ($m[1] == "username") {
         $data[$m[1]] = $m[3] ? trim($m[3], "\",'") : trim(urldecode($m[4]), "\",'");
      } else {
         $data[$m[1]] = $m[3] ? trim($m[3], "\",'") : trim($m[4], "\",'");
      }
      unset($needed_parts[$m[1]]);
   }

   return $needed_parts ? false : $data;
}
require "../connections/Utils.php";
$UserId = -1;
$UserAccessLevel = 0;
$UserAccessCamMask = [];
$UserAccessServerMask = [];
$ServerVersion = [0, 0, 0, 0];

function isV1LessV2orEq($v1, $v2)
{
   // порядок не менять
   if ($v1[0] > $v2[0]) {
      return false;
   }
   if ($v1[0] == $v2[0]) {
      if ($v1[1] > $v2[1]) {
         return false;
      }
      if ($v1[1] == $v2[1]) {
         if ($v1[2] > $v2[2]) {
            return false;
         }
         if ($v1[2] == $v2[2] && $v1[3] > $v2[3]) {
            return false;
         }
      }
   }
   return true;
}

function Send($sock, $str)
{
   socket_set_block($sock);
   $bytes = mb_strlen($str, "windows-1251");
   $str .= "\n";
   $n = socket_send($sock, $str, $bytes + 1, MSG_DONTROUTE);
   $sended = $n;
   #echo 'Send '.$str.' len '.$bytes.' bytes sended:'.$sended.';'." time=".time()."<br>\n";
}

function Recv($sock)
{
   socket_set_nonblock($sock);
   $total_buf = "";
   $try = 0;
   $n = 1;

   do {
      usleep(1000);
      $try += 1;
      if ($n > 0) {
         $buf = socket_read($sock, 4096);
         if ($buf === "") {
            break;
         }
         if (strpos($buf, "\r\n")) {
            $total_buf .= trim($buf);
            break;
         }
         $total_buf .= $buf;
      }
   } while ($try <= 2000);

   return $total_buf;
}

function RecvUpdate($sock)
{
   socket_set_nonblock($sock);
   $total_buf = "";
   $try = 0;
   $n = 1;
   $time_start = microtime(true);
   $time_common = 0;
   do {
      usleep(10000);
      $try += 1;
      if ($n > 0) {
         $buf = socket_read($sock, 4096);
         if ($buf === "") {
            //, PHP_NORMAL_READ);
            break;
         }
         if ($buf == "") {
         } else {
            if (strpos($buf, "\r\n")) {
               $total_buf .= trim($buf);
               $time_common = microtime(true) - $time_start;
               break;
            }
            $total_buf .= $buf;
         }
      }
   } while ($try <= 10000);
   if ($try >= 10000) {
      header("HTTP/1.1 408 Request Timeout");
      $time_common = -1;
   }
   return $time_common;
}

function Connect()
{
   $sock = socket_create(AF_UNIX, SOCK_STREAM, 0);
   $sock_path = "/tmp/procA";
   if (!@socket_connect($sock, $sock_path)) {
      socket_close($sock);
      $sock = -1;
      header("HTTP/1.1 503 Service Unavailable");
      die("No connection with server process");
   }
   return $sock;
}
function Nonce()
{
   $sock = Connect();
   $nonce = uniqid();
   $str = "NONCE " . $nonce;
   Send($sock, $str);
   socket_close($sock);
   return $nonce;
}

function Login()
{
   global $realm,
      $UserId,
      $UserAccessLevel,
      $ServerVersion,
      $MinServerVersion,
      $UserAccessServerMask,
      $UserAccessCamMask;

   $sock = Connect();
   $digest = http_digest_parse($_SERVER["PHP_AUTH_DIGEST"]);
   if (!$digest) {
      die("Bad digest");
   }
   $php_auth =
      'username="' .
      ConvertUTF2Native_win1251($digest["username"]) .
      '", realm="' .
      $digest["realm"] .
      '", ' .
      'nonce="' .
      $digest["nonce"] .
      '", uri="' .
      $digest["uri"] .
      '", response="' .
      $digest["response"] .
      '", ' .
      'opaque="' .
      $digest["opaque"] .
      '", qop="' .
      $digest["qop"] .
      '", nc=' .
      $digest["nc"] .
      ', cnonce="' .
      $digest["cnonce"] .
      '"';

   $str =
      "LOGIN method=\"" .
      $_SERVER["REQUEST_METHOD"] .
      "\", remote=\"" .
      $_SERVER["REMOTE_ADDR"] .
      "\", " .
      $php_auth;
   Send($sock, $str);
   $response = Recv($sock);
   //die($response."<br>");
   $arr = explode(" ", $response);
   if (isset($arr[0])) {
      $UserId = $arr[0];
      if (isset($arr[1])) {
         $UserAccessLevel = $arr[1];
         if (isset($arr[2])) {
            $ServerVersion = explode(".", $arr[2]);
         }

         if (isset($arr[3])) {
            $accessServerMask = explode(",", $arr[3]);
            foreach ($accessServerMask as $k) {
               array_push($UserAccessServerMask, hexdec($k));
            }
         }
         if (isset($arr[4])) {
            $accessCamMask = explode(",", $arr[4]);
            foreach ($accessCamMask as $k) {
               array_push($UserAccessCamMask, hexdec($k));
            }
         }
      }
   }
   if ($ServerVersion[0] < 2) {
      $explain_msg = "Server bad response " . $response;
      die($explain_msg);
   }
   if ($UserId < 0) {
      if ($UserId == -2) {
         sleep(5);
         header("HTTP/1.1 401 Unauthorized ");
         $explain_msg = "Bad logins were too fast! WebServer is blocked. Try 1 minute later";
      } else {
         print_unauth_header();
         socket_close($sock);
         $explain_msg = "Wrong login name or password! Relogin";
      }
      die($explain_msg);
   } elseif ($UserAccessLevel < 1 || !isV1LessV2orEq($MinServerVersion, $ServerVersion)) {
      socket_close($sock);
      $explain_msg =
         "Server version " .
         $ServerVersion[0] .
         "." .
         $ServerVersion[1] .
         "." .
         $ServerVersion[1] .
         "." .
         $ServerVersion[2] .
         "." .
         $ServerVersion[3] .
         " is too old for WebServer scripts! Use Domination Client to update server software first";
      die($explain_msg);
   }
   #echo "Login answer: ".$response."<br>";
   return $sock;
}
function ParamGet($sock, $param)
{
   $str = "GET " . $param;
   Send($sock, $str);
   $response = Recv($sock);

   if (strlen($response) == 0) {
      return [];
   }
   //если возвращается пустая строка, то ясно дело будет ошибка JSON декодирования

   #$response = str_replace("\\\\", "\u005c", $response);
   $json = mb_convert_encoding($response, "UTF-8", "Windows-1251");
   $json = str_replace("\\", "\\\\", $json);
   $arr = json_decode($json);

   $err = json_last_error();

   if ($err != 0) {
      $lastError = json_last_error_msg();
      $error_text = "";
      switch (json_last_error()) {
         case JSON_ERROR_NONE:
            $error_text = "JSON_ERROR_NONE"; // 'Ошибок нет';
            break;
         case JSON_ERROR_DEPTH:
            $error_text = "JSON_ERROR_DEPTH"; // 'Достигнута максимальная глубина стека';
            break;
         case JSON_ERROR_STATE_MISMATCH:
            $error_text = "JSON_ERROR_STATE_MISMATCH"; // 'Некорректные разряды или несоответствие режимов';
            break;
         case JSON_ERROR_CTRL_CHAR:
            $error_text = "JSON_ERROR_CTRL_CHAR"; // 'Некорректный управляющий символ';
            break;
         case JSON_ERROR_SYNTAX:
            $error_text = "JSON_ERROR_SYNTAX"; // 'Синтаксическая ошибка, некорректный JSON';
            break;
         case JSON_ERROR_UTF8:
            $error_text = "JSON_ERROR_UTF8"; // 'Некорректные символы UTF-8, возможно неверно закодирован';
            break;
         default:
            $error_text = "UNKNOW_ERROR"; // 'Неизвестная ошибка';
            break;
      }
      $explain = $error_text . "" . $lastError;
      try {
         $myfile = fopen($_SERVER["DOCUMENT_ROOT"] . "/LAST_JSON_INVALID.txt", "wb");
         $txt = $json;
         fwrite($myfile, $txt);
         fclose($myfile);
         $explain = $explain . " Please, analyze LAST_JSON_INVALID.txt in root directory";
      } catch (Exception $e) {
         // echo 'Поймано исключение: ',  $e->getMessage(), "\n";
      } finally {
         echo json_encode(["param" => $str, "explain" => $explain]);
         Header("HTTP/1.0 550 JSON Error");
         die();
      }

      // throw new Exception($error_text);
      return [];
   }
   return $arr;
}
function ParamSetString($sock, $param, $value, $isConvertWind = true)
{
   $success = false;
   $value1251 = $isConvertWind ? mb_convert_encoding($value, "Windows-1251", "UTF-8") : $value;
   $str = "SET " . $param . "=\"" . $value1251 . "\"";
   Send($sock, $str);
   $response = Recv($sock); //returns 'true' or 'false' due to access level enough
   if ($response == "true") {
      $success = true;
   }

   return $success;
}
function ParamSetInt($sock, $param, $value)
{
   $success = false;
   $str = "SET " . $param . "=" . $value;
   Send($sock, $str);
   $response = Recv($sock); //returns 'true' or 'false' due to access level enough
   if ($response == "true") {
      $success = true;
   }

   return $success;
}
function ParamUnset($sock, $param)
{
   $success = false;
   $str = "UNSET " . $param;
   Send($sock, $str);
   $response = Recv($sock); //returns 'true' or 'false' due to access level enough
   if ($response == "true") {
      $success = true;
   }

   return $success;
}
function ParamMultiSetInt($sock, $param, $value, $start_index, $end_index)
{
   $str = "MSET " . $param . " " . $value . " " . (string) $start_index . " " . (string) $end_index;
   Send($sock, $str);
   $response = Recv($sock); //returns NULL always because of many params
}
// Server
function ServerUpdate($sock, $file)
{
   $str = "UPDATE vi=" . $file;
   Send($sock, $str);
   $responseTime = RecvUpdate($sock);
   return $responseTime;
}
function ServerUpdateWeb($sock, $file)
{
   $str = "UPDATE web=" . $file;
   Send($sock, $str);
   $responseTime = RecvUpdate($sock);
   return $responseTime;
}
function ServerReboot($sock)
{
   $str = "HALT reboot";
   Send($sock, $str);
   $response = Recv($sock);

   return $response == "true";
}
function ServerRestart($sock)
{
   $str = "HALT restart";
   Send($sock, $str);
   $response = Recv($sock);

   return $response == "true";
}

// Users
function UserAdd($sock, $login, $passwd, $accesslevel)
{
   $login_win = ConvertUTF2Native_win1251($login);
   $passwd_win = ConvertUTF2Native_win1251($passwd);
   $str = "USERADD \"" . $login_win . "\" " . $passwd_win . " " . $accesslevel;
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
function UserDel($sock, $index)
{
   $str = "USERDEL " . $index;
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
function ServersDiscovery($sock)
{
   $str = "SERVERS Discovery";
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
function ServersDiscoveryClear($sock)
{
   $str = "SERVERS Clear";
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
// check on type data
function checkReceivedFile($object)
{
   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }
   if (!is_array($object) || isContainNull($object)) {
      header("HTTP/1.1 400 Bad Request");
      die();
   }
}
